/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWStepRuleSubPanel;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWCustomTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class VWStepRuleTab
extends JPanel
implements IVWPropertyTab,
IVWPropertyChangeListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWCustomTabbedPane m_tabbedPane = null;
    private VWStepRuleSubPanel m_beforeRadioButton = null;
    private VWStepRuleSubPanel m_onSaveRadioButton = null;
    private VWStepRuleSubPanel m_afterRadioButton = null;

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        this.m_authPropertyData = authPropertyData;
        this.createControls(vwMapNode);
        this.setSelectedStep(vwMapNode);
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        try {
            if (this.m_beforeRadioButton != null) {
                this.m_beforeRadioButton.setSelectedStep(vwMapNode);
            }
            if (this.m_onSaveRadioButton != null) {
                this.m_onSaveRadioButton.setSelectedStep(vwMapNode);
            }
            if (this.m_afterRadioButton != null) {
                this.m_afterRadioButton.setSelectedStep(vwMapNode);
            }
            if (this.m_tabbedPane != null && this.m_tabbedPane.getTabCount() > 0) {
                this.m_tabbedPane.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        if (this.m_tabbedPane != null) {
            this.m_tabbedPane.releaseReferences();
            this.m_tabbedPane = null;
        }
        if (this.m_beforeRadioButton != null) {
            this.m_beforeRadioButton.releaseReferences();
            this.m_beforeRadioButton = null;
        }
        if (this.m_onSaveRadioButton != null) {
            this.m_onSaveRadioButton.releaseReferences();
            this.m_onSaveRadioButton = null;
        }
        if (this.m_afterRadioButton != null) {
            this.m_afterRadioButton.releaseReferences();
            this.m_afterRadioButton = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            switch (event.getID()) {
                case 541: 
                case 542: 
                case 543: 
                case 544: {
                    this.reinitialize();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(VWMapNode vwMapNode) {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_tabbedPane = new VWCustomTabbedPane(1);
            this.add((Component)this.m_tabbedPane, "Center");
            if (vwMapNode != null) {
                int nStepType = VWStepUtils.getStepType(vwMapNode);
                if (nStepType != 0) {
                    this.m_beforeRadioButton = new VWStepRuleSubPanel(this.m_authPropertyData, 0);
                    if (this.m_beforeRadioButton != null) {
                        this.m_tabbedPane.addTab(VWResource.s_beforeExecutionStr, this.m_beforeRadioButton);
                    }
                }
                if (VWStepUtils.isGeneralStep(nStepType) || VWStepUtils.isStartGeneralStep(nStepType)) {
                    this.m_onSaveRadioButton = new VWStepRuleSubPanel(this.m_authPropertyData, 1);
                    if (this.m_onSaveRadioButton != null) {
                        this.m_tabbedPane.addTab(VWResource.s_onSave, this.m_onSaveRadioButton);
                    }
                }
            }
            this.m_afterRadioButton = new VWStepRuleSubPanel(this.m_authPropertyData, 2);
            if (this.m_afterRadioButton != null) {
                this.m_tabbedPane.addTab(VWResource.s_afterCompletionStr, this.m_afterRadioButton);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void reinitialize() {
        try {
            if (this.m_beforeRadioButton != null) {
                this.m_beforeRadioButton.reinitialize();
            }
            if (this.m_onSaveRadioButton != null) {
                this.m_onSaveRadioButton.reinitialize();
            }
            if (this.m_afterRadioButton != null) {
                this.m_afterRadioButton.reinitialize();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

